import { Pressable, ScrollView, Text, View } from "react-native";
import React from "react";
import SingleVariation from "./SingleVariation";
import CustomModal from "../../../../../../../src/components/CustomModal/CustomModal";
import ProgressiveImage from "../../../../../../../src/components/ProgressiveImage";
import VariationContentStyle from "./VariationContent.style";
import TimesIcon from "../../../../../../../assets/svgs/drawer/times.svg";
import ResetIcon from "../../../../../../../assets/svgs/circular.svg";
import SimpleNvariable from "../../../Footer/SimpleNvariable";
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { dataProcessing } from "../../../utils/dataProcess";
import { useState } from "react";
import { matchVariation } from "../../../utils/matchVariation";
import {
    storeItemInCart,
    storeItemInCartDataProcess,
} from "../../../../../../../redux/slices/cart/storeItemInCart";
import useAuth from "../../../../../../../hooks/useAuth";
import useCustomToast from "../../../../../../../hooks/useCustomToast";
import { useNavigation } from "@react-navigation/native";
import Toast from "react-native-toast-message";
import { getCartProduct } from "../../../../../../../redux/slices/cart/getCartProducts";
import usePreferences from "../../../../../../../hooks/usePreferences";
import ItemStock from "../ItemStock";
import ItemPrice from "../ItemPrice";

import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../../../../../hooks/useLangTranslation";
import { compareWithTodaysDate } from "../../../../../../../helper/compareWithTodaysDate";
import { useNumberFormat } from "../../../../../../../helper/numberFormat";
import useProcessPrice from "../../../../../../../hooks/useProcessPrice";
import CustomSVG from "../../../../../../../src/components/CustomSVG/CustomSVG";
import { resetVariation } from "../../../../../../../redux/slices/featureProducts/items/itemVariations";
import dpr from "../../../../../../Utilities/CustomStyleAttribute/dpr";

const VariationContent = (props) => {
    const { trans } = useLangTranslation();
    const {
        productDetails,
        onCloseModal,
        setSelectedDimensions,
        price: totalPrice,
    } = props;
    const variationContentStyle = VariationContentStyle();

    const {
        code,
        name,
        featured_image,
        type,
        meta,
        stock_hide,
        stock_quantity,
        stock_status,
        manage_stocks,
        backorders,
        critical_stock_quantity,
        variations: variationsArray,
        isEnableB2B,
        b2bData
    } = productDetails?.data || {};

    const b2b = {
        isEnableB2B,
        b2bData
    };

    const { product_inventory: { manage_stock } = {} } = usePreferences();
    const { access_token } = useAuth();
    const dispatch = useDispatch();
    const showToast = useCustomToast();
    const navigation = useNavigation();
    const storeItemInCartUrl = `${BASE_API_URL_STG}/user/cart/store`;
    const [inputData, setInputData] = useState({
        code: null,
        variation_id: null,
    });
    const [price, setPrice] = useState(totalPrice);
    const variationData = useSelector((state) => state.itemVariationReducer);
    const { cartLoading } = useSelector((state) => state.storeItemInCartSlice);
    const [variations, setVariation] = useState({});
    const [disableBtn, setDisableBtn] = useState(true);
    const [isValue, setIsValue] = useState(false);
    const initialStock = {
        stock_status: productDetails?.data?.stock_status,
        stock_quantity: productDetails?.data?.stock_quantity,
        manage_stocks: productDetails?.data?.manage_stocks,
        backorders: productDetails?.data?.backorders,
        criticalStockQuantity: productDetails?.data?.critical_stock_quantity,
    };
    const [stockManage, setStockManage] = useState(initialStock);
    const [quantity, setQuantity] = useState(1);
    const [selectedVariation, setSelectedVariation] = useState(null);
    const [resetVariant, setResetVariant] = useState(false);
    const { value: { manage_stocks: variationManageStock, images } = {} } =
        selectedVariation || {};

    useEffect(() => {
        if (selectedVariation?.value?.dimensions) {
            setSelectedDimensions(selectedVariation?.value?.dimensions);
        }
    }, [selectedVariation]);

    const isEmptyVariant = variationData &&
        typeof variationData === "object" &&
        Object.keys(variationData).length > 0 &&
        Object.values(variationData).every(value => value === "");

    const numberFormat = useNumberFormat();
    const processPrice = useProcessPrice();
    useEffect(() => {
        if (type == "Variable Product") {
            let regularPrice = [];
            let salePrice = [];
            for (let item of variationsArray) {
                const {
                    regular_price_formatted,
                    sale_from,
                    sale_to,
                    sale_price_formatted,
                } = item;
                let rp = numberFormat(regular_price_formatted);
                let sp = numberFormat(sale_price_formatted);
                let isSaleAvailable = compareWithTodaysDate(sale_from, sale_to);
                regularPrice.push(rp);
                if (sale_price_formatted && isSaleAvailable) {
                    salePrice.push(sp || rp);
                }
            }
            setPrice({
                regularPrice: `${processPrice(
                    Math.min(...regularPrice)
                )} - ${processPrice(Math.max(...regularPrice))}`,
                salePrice:
                    salePrice.length > 0
                        ? `${processPrice(
                              Math.min(...salePrice)
                          )} - ${processPrice(Math.max(...salePrice))}`
                        : null,
            });
        }
    }, []);
    useEffect(() => {
        if (Object.keys(productDetails).length) {
            if (type === "Variable Product") {
                let { status, obj: dataObj } = dataProcessing(
                    productDetails,
                    variationData
                );
                if (status) {
                    setQuantity(1);
                    setVariation(dataObj);
                    let matchItem = matchVariation(
                        productDetails,
                        variationData
                    );
                    if (matchItem?.success) {
                        setSelectedVariation(matchItem);
                        setStockManage({
                            ...stockManage,
                            stock_status:
                                matchItem?.value?.backorder == 1 ||
                                matchItem?.value?.total_stocks > 0
                                    ? trans("In Stock")
                                    : trans("Out Of Stock"),
                            stock_quantity: matchItem?.value?.total_stocks
                                ? Number(matchItem?.value?.total_stocks)
                                : 0,
                            manage_stocks: matchItem?.value?.manage_stocks,
                            backorders: matchItem?.value?.backorder,
                            criticalStockQuantity:
                                matchItem?.value?.critical_stock_quantity || 5,
                        });
                        const {
                            regular_price_formatted,
                            sale_from,
                            sale_to,
                            sale_price_formatted,
                        } = matchItem?.value;
                        let isSaleAvailable = compareWithTodaysDate(
                            sale_from,
                            sale_to
                        );
                        setPrice({
                            regularPrice: regular_price_formatted,
                            salePrice:
                                sale_price_formatted && isSaleAvailable
                                    ? sale_price_formatted
                                    : null,
                        });

                        setInputData({
                            code: code,
                            variation_id: matchItem?.value?.id,
                        });
                    } else {
                        setSelectedVariation(null);
                    }
                }
                if (Object.keys(variationData).length) {
                    let value = Object.keys(variationData).every(
                        (k) => variationData[k] != ""
                    );
                    setIsValue(value);
                }
            }
        }
    }, [variationData]);
    useEffect(() => {
        if (type == "Variable Product") {
            if (isValue) {
                VP();
            } else if (!isValue) {
                setDisableBtn(true);
            }
        }
        function SP(manage_stocks) {
            if (manage_stocks) {
                if (stockManage?.backorders == 0) {
                    if (stockManage?.stock_quantity > 0) {
                        setDisableBtn(false);
                    } else if (stockManage?.stock_quantity <= 0) {
                        setDisableBtn(true);
                    }
                } else if (stockManage?.backorders == 1) {
                    setDisableBtn(false);
                }
            } else {
                if (
                    stockManage?.stock_status?.toLowerCase() == "out of stock"
                ) {
                    setDisableBtn(true);
                } else {
                    setDisableBtn(false);
                }
            }
        }

        function VP() {
            if (variationManageStock) {
                SP(variationManageStock);
            } else {
                setStockManage({
                    ...stockManage,
                    stock_quantity: stock_quantity,
                    stock_status: stock_status,
                    manage_stocks: manage_stocks,
                    backorders: backorders,
                    criticalStockQuantity: critical_stock_quantity,
                });
                SP(stockManage?.manage_stocks);
            }
        }
    }, [
        isValue,
        productDetails?.data?.id,
        stockManage?.stock_quantity,
        stockManage?.stock_status,
        selectedVariation,
    ]);
    const handleAddToCart = async () => {
        let cartData = {
            ...inputData,
            qty: quantity,
        };
        try {
            const res = await dispatch(
                storeItemInCart({ access_token, storeItemInCartUrl, cartData })
            );
            handleCloseModal();
            const { code, message } = storeItemInCartDataProcess(res?.payload);
            if (code == 200) {
                if (stockManage?.stock_quantity > 0) {
                    const qty =
                        stockManage.backorders == 1
                            ? Number(stockManage?.stock_quantity)
                            : Number(stockManage?.stock_quantity - quantity);

                    setStockManage({
                        ...stockManage,
                        stock_quantity: qty,
                        stock_status:
                            stockManage.backorders == 1 || qty > 0
                                ? trans("In Stock")
                                : trans("Out Of Stock"),
                    });
                }
                setQuantity(1);
            }
            showToast({
                text1: trans(message),
                text2: trans("Visit Cart"),
                type: "addToCart",
                position: "bottom",
                bottomOffset: 60,
                visibilityTime: 2000,
                props: {
                    func: () => {
                        navigation.navigate("my cart");
                        Toast.hide();
                    },
                },
            });

            const CARTURL = `${BASE_API_URL_STG}/user/carts`;
            dispatch(getCartProduct({ access_token, CARTURL }));
        } catch (error) {}
    };

    const handleCloseModal = () => {
        setPrice(totalPrice);
        onCloseModal();
    };

    const handleClearVariation = () => {
        dispatch(resetVariation());
        setSelectedVariation(null);
        setResetVariant(prev => !prev);
    };

    return (
        <CustomModal setPrice={setPrice} {...props}>
            <View style={variationContentStyle.variationCont}>
                <Pressable
                    android_ripple={variationContentStyle.iconRipple}
                    onPress={handleCloseModal}
                    style={variationContentStyle.headerIcon}
                >
                    <CustomSVG svgIcon={TimesIcon} fill={"#000000"} />
                </Pressable>
                <View style={variationContentStyle.headerCont}>
                    {Array.isArray(images) && images.length > 0 ? (
                        <ProgressiveImage
                            source={{ uri: featured_image || images[0] }}
                            style={variationContentStyle.image}
                        />
                    ) : (
                        <ProgressiveImage
                            source={{ uri: images || featured_image }}
                            style={variationContentStyle.image}
                        />
                    )}

                    <View>
                        <Text
                            numberOfLines={3}
                            style={variationContentStyle.name}
                        >
                            {name}
                        </Text>
                        <ItemPrice
                            price={price}
                            type={type}
                            selectedVariation={selectedVariation}
                            b2b={b2b}
                        />
                    </View>
                </View>
                <ScrollView
                    showsVerticalScrollIndicator={false}
                    overScrollMode={"never"}
                >
                    {manage_stock == "1" &&
                        stock_hide != 1 &&
                        selectedVariation?.success && (
                            <View style={variationContentStyle.stockCont}>
                                <ItemStock
                                    type={type}
                                    stockManage={stockManage}
                                    stock_hide={stock_hide}
                                    selectedVariation={selectedVariation}
                                    isStock={disableBtn}
                                />
                            </View>
                        )}
                    {Object.keys(variations ?? {})?.map((item, index) => (
                        <SingleVariation
                            key={index}
                            item={item}
                            variations={variations}
                            resetVariant={resetVariant}
                        />
                    ))}
                </ScrollView>
            </View>
            <View style={variationContentStyle.typeVariable}>
                {type == "Variable Product" && (
                    <>
                        {variationData && Object.keys(variationData).length > 0 && !isEmptyVariant && (
                            <View style={variationContentStyle.clearVariation}>
                                <Pressable onPress={handleClearVariation} style={variationContentStyle.clearVariationInner}>
                                    <Text style={variationContentStyle.variationTitle}>{trans("Clear")}</Text>
                                    <CustomSVG svgIcon={ResetIcon} fill={"#000000"} height={dpr(20)} width={dpr(20)} />
                                </Pressable>
                            </View>
                        )}
                        <SimpleNvariable
                            meta={meta}
                            stockManage={stockManage}
                            quantity={quantity}
                            setQuantity={setQuantity}
                            disableBtn={disableBtn}
                            cartLoading={cartLoading}
                            handleAddToCart={handleAddToCart}
                        />
                    </>
                )}
            </View>
        </CustomModal>
    );
};

export default VariationContent;
